 


IF NOT EXISTS(SELECT * 
                FROM INFORMATION_SCHEMA.TABLES
			   WHERE TABLE_NAME='TELE_EMPRESA_TIPO_ENTREGA')
BEGIN
	CREATE TABLE TELE_EMPRESA_TIPO_ENTREGA ( 
		CD_CTR					INT NOT NULL IDENTITY(1,1), 
		CD_EMP_ENTREGA			INT NOT NULL , 
		DS_TIPO_ENTREGA_EMPRESA VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL , 
		CODIGO_ENTREGA_EMPRESA  INT NOT NULL, 
		ATIVO                   INT NOT NULL,
		 CONSTRAINT PK_TELE_EMPRESA_TIPO_ENTREGA PRIMARY KEY CLUSTERED  ( CD_CTR  ASC ) ) 
	
	ALTER TABLE TELE_EMPRESA_TIPO_ENTREGA ADD CONSTRAINT DF_TELE_EMPRESA_TIPO_ENTREGA_ATIVO DEFAULT 1 FOR ATIVO;
	
	ALTER TABLE TELE_EMPRESA_TIPO_ENTREGA   WITH CHECK ADD  CONSTRAINT  FK_TELE_EMPRESA_TIPO_ENTREGA_CD_EMP_ENTREGA  FOREIGN KEY( CD_EMP_ENTREGA )	REFERENCES   TELE_EMPRESA_ENTREGA  ( CD_EMP_ENTREGA );

	ALTER TABLE TELE_EMPRESA_TIPO_ENTREGA  CHECK CONSTRAINT  FK_TELE_EMPRESA_TIPO_ENTREGA_CD_EMP_ENTREGA;
	
	CREATE UNIQUE INDEX UX_TELE_EMPRESA_TIPO_ENTREGA_CD_EMP_ENTREGA_CODIGO_ENTREGA_EMPRESA ON TELE_EMPRESA_TIPO_ENTREGA (CD_EMP_ENTREGA, CODIGO_ENTREGA_EMPRESA);
END;
